#define ACRTC_BASE            0xAA0000       /* device address        */
#define HRES 640                             /* horizontal resolution */
#define VRES 480                             /* vertical resolution   */
#define PIXW  4                              /* pixels per word       */



#define board_acrtc           0xAA0000
#define board_acrtc_cp        0xA90000

#define acrtc_base_addr       board_acrtc         /* acrtc graphics controller */
#define acrtc_cp_base_addr    board_acrtc_cp+1    /* colour palette (ramdac) */

/* general acrtc/graphics parameters */

#define acrtc_hr        640                 /* horizontal resolution */
#define acrtc_vr        480                 /* vertical resolution */
#define acrtc_dn        1                   /* display number (0-3) */

/* acrtc registers */

// #define acrtc_ar     0x00                 /* address register */
// #define acrtc_sr     0x00                 /* status register */
// #define acrtc_io     0x02                 /* register i/o port */

#define acrtc_fe        0x00                 /* fifo entry */
#define acrtc_ccr       0x02                 /* command control register */
#define acrtc_omr       0x04                 /* operation mode register */
#define acrtc_dcr       0x06                 /* display control register */

#define acrtc_rcr       0x80                 /* raster count register */
#define acrtc_hsr       0x82                 /* horizontal sync register */
#define acrtc_hdr       0x84                 /* horizontal display register */
#define acrtc_vsr       0x86                 /* vertical sync register */
#define acrtc_vdr       0x88                 /* vertical display register */
#define acrtc_ssw       0x8A                 /* split screen width register */
#define acrtc_ssw2      0x8C
#define acrtc_ssw3      0x8E
#define acrtc_bcr       0x90                 /* blink control register */
#define acrtc_hwr       0x92                 /* horizontal window display register */
#define acrtc_vwr       0x94                 /* vertical window display register */
#define acrtc_vwr2      0x96
#define acrtc_gcr       0x98                 /* graphic cursor register */
#define acrtc_gcr2      0x9A
#define acrtc_gcr3      0x9C

#define acrtc_rar0      0xC0                 /* upper (background) - raster address 0 register */
#define acrtc_mwr0      0xC2                 /* upper (background) - memory width 0 register */
#define acrtc_sar0      0xC4                 /* upper (background) - start address 0 register */
#define acrtc_sar02     0xC6
#define acrtc_rar1      0xC8                 /* base (background) - raster address 1 register */
#define acrtc_mwr1      0xCA                 /* base (background) - memory width 1 register */
#define acrtc_sar1      0xCC                 /* base (background) - start address 1 register */
#define acrtc_sar12     0xCE
#define acrtc_rar2      0xD0                 /* lower (background) - raster address 2 register */
#define acrtc_mwr2      0xD2                 /* lower (background) - memory width 2 register */
#define acrtc_sar2      0xD4                 /* lower (background) - start address 2 register */
#define acrtc_sar22     0xD6
#define acrtc_rar3      0xD8                 /* window - raster address 3 register */
#define acrtc_mwr3      0xDA                 /* window - memory width 3 register */
#define acrtc_sar3      0xDC                 /* window - start address 3 register */
#define acrtc_sar32     0xDE
#define acrtc_bcur1     0xE0                 /* block cursor 1 register */
#define acrtc_bcur12    0xE2
#define acrtc_bcur2     0xE4                 /* block cursor 2 register */
#define acrtc_bcur22    0xE6
#define acrtc_cdr       0xE8                 /* cursor definition register */
#define acrtc_zfr       0xEA                 /* zoom factor register */
#define acrtc_lpar      0xEC                 /* light pen address register */
#define acrtc_lpar2     0xEE

/* acrtc parameter registers */

#define acrtc_cl0       0x00                 /* color 0 parameter register */
#define acrtc_cl1       0x01                 /* color 1 parameter register */
#define acrtc_ccmp      0x02                 /* color comparison parameter register */
#define acrtc_edg       0x03                 /* edge color parameter register */
#define acrtc_mask      0x04                 /* mask parameter register */
#define acrtc_prc       0x05                 /* pattern ram control parameter register */
#define acrtc_adr       0x08                 /* area definition parameter register */
#define acrtc_rwp       0x0C                 /* read write pointer parameter register */
#define acrtc_dp        0x10                 /* drawing pointer parameter register */
#define acrtc_cp        0x12                 /* current pointer parameter register */

/* acrtc status register bits */

#define WFR 1                                /* write fifo ready      */
#define CED 5                                /* command end           */

/* acrtc register access commands */

#define acrtc_org       0x0400               /* origin command */
#define acrtc_wpr       0x0800               /* write parameter register command */
#define acrtc_rpr       0x0C00               /* read parameter register command */
#define acrtc_wptn      0x1800               /* write pattern ram command */
#define acrtc_rptn      0x1C00               /* read pattern ram command */

/* acrtc data transfer commands */

#define acrtc_drd       0x2400               /* dma read command */
#define acrtc_dwt       0x2800               /* dma write command */
#define acrtc_dmod      0x2C00               /* dma modify command */
#define acrtc_rd        0x4400               /* read command */
#define acrtc_wt        0x4800               /* write command */
#define acrtc_mod       0x4C00               /* modify command */
#define acrtc_clr       0x5800               /* clear command */
#define acrtc_sclr      0x5C00               /* selective clear command */
#define acrtc_cpy       0x6000               /* copy command */
#define acrtc_scpy      0x7000               /* selective copy command */

/* acrtc graphic commands */

#define acrtc_amove     0x8000               /* absolute move command */
#define acrtc_rmove     0x8400               /* relative move command */
#define acrtc_aline     0x8800               /* absolute line command */
#define acrtc_rline     0x8C00               /* relative line command */
#define acrtc_arct      0x9000               /* absolute rectangle command */
#define acrtc_rrct      0x9400               /* relative rectangle command */
#define acrtc_apll      0x9800               /* absolute polyline command */
#define acrtc_rpll      0x9C00               /* relative polyline command */
#define acrtc_aplg      0xA000               /* absolute polygon command */
#define acrtc_rplg      0xA400               /* relative polygon command */
#define acrtc_crcl      0xA800               /* circle command */
#define acrtc_elps      0xAC00               /* ellipse command */
#define acrtc_aarc      0xB000               /* absolute arc command */
#define acrtc_rarc      0xB400               /* relative arc command */
#define acrtc_aearc     0xB800               /* absolute ellipse arc command */
#define acrtc_rearc     0xBC00               /* relative ellipse arc command */
#define acrtc_afrct     0xC000               /* absolute filled rectangle command */
#define acrtc_rfrct     0xC400               /* relative filled rectangle command */
#define acrtc_paint     0xC800               /* paint command */
#define acrtc_dot       0xCC00               /* dot command */
#define acrtc_ptn       0xD000               /* pattern command */
#define acrtc_agcpy     0xE000               /* absolute graphic copy command */
#define acrtc_rgcpy     0xF000               /* relative graphic copy command */

// #define CLR          0x5800
// #define AMOVE        0x8000
// #define ALINE        0x8800
// #define ARCT         0X9000
// #define CRCL         0xA800
// #define DOT          0xCC00

// acrtc colour palette registers

#define acrtc_cp_parw   0                    /* pixel address register (write) */
#define acrtc_cp_cpr    2                    /* colour palette ram */
#define acrtc_cp_prmr   4                    /* pixel read mask register */
#define acrtc_cp_parr   6                    /* pixel address register (read) */

// mivac mode 5 parameters

#define mivac_mode_5_pw     4                           /* pixels per word */
#define mivac_mode_5_mw1    acrtc_hr/mivac_mode_5_pw    /* memory width in words */
#define mivac_mode_5_gbm    0b010                       /* graphic bit mode [4-bits/pixel] */
#define mivac_mode_5_atr    0b0101                      /* mivac mode */
#define mivac_mode_5_gai    0b010                       /* graphic address increment [+4] */
#define mivac_mode_5_acm    0b00                        /* access mode [single access mode] */

