#include "acrtc.h"

uint16_t *acrtc_ar=(uint16_t*)ACRTC_BASE;               /* pointer - address register  */
uint16_t *acrtc_sr=(uint16_t*)ACRTC_BASE;               /* pointer - status register   */
uint16_t *acrtc_io=(uint16_t*)ACRTC_BASE+1;             /* pointer - register i/o port */

uint8_t *ptr_acrtc_cp_parw=(uint8_t*)acrtc_cp_base_addr+acrtc_cp_parw;
uint8_t *ptr_acrtc_cp_cpr=(uint8_t*)acrtc_cp_base_addr+acrtc_cp_cpr;

struct rgb{
    uint8_t red;
    uint8_t green;
    uint8_t blue;
};

// 16-colour palette (ega colours)
// palette_16a:

struct rgb colours[16]={
    {0x00,0x00,0x00},    /* colour 0  - black */
    {0x00,0x00,0xAA},    /* colour 1  - blue */
    {0x00,0xAA,0x00},    /* colour 2  - green */
    {0x00,0xAA,0xAA},    /* colour 3  - cyan */
    {0xAA,0x00,0x00},    /* colour 4  - red */
    {0xAA,0x00,0xAA},    /* colour 5  - magenta */
    {0xAA,0x55,0x00},    /* colour 6  - yellow/brown */
    {0xAA,0xAA,0xAA},    /* colour 7  - white/light grey */
    {0x55,0x55,0x55},    /* colour 8  - dark grey/bright black */
    {0x55,0x55,0xFF},    /* colour 9  - bright blue */
    {0x55,0xFF,0x55},    /* colour 10 - bright green */
    {0x55,0xFF,0xFF},    /* colour 11 - bright cyan */
    {0xFF,0x55,0x55},    /* colour 12 - bright red */
    {0xFF,0x55,0xFF},    /* colour 13 - bright magenta */
    {0xFF,0xFF,0x55},    /* colour 14 - bright yellow */
    {0xFF,0xFF,0xFF},    /* colour 15 - bright white */
    };

chk_ced()
{
    uint16_t status;
    status=(uint16_t)*acrtc_sr;
    status &= 1<<CED;
    while(status==0)
    {
        status=(uint16_t)*acrtc_sr;
//      printf("not ready for command - status $%04x\n",status);
        status &= 1<<CED;
    }
}

chk_wfr()
{
    uint16_t status;
    status=(uint16_t)*acrtc_sr;
    status &= 1<<WFR;
    while(status==0)
    {
        status=(uint16_t)*acrtc_sr;
        printf("fifo not ready - status $%04x\n",status);
        status &= 1<<WFR;
    }
}

reg_write(reg,data)
{
    *acrtc_ar=reg;
    *acrtc_io=data;
}

pr_write(pr,data)
uint16_t pr,data;
{
    fifo_write(pr+0x0800);
    fifo_write(data);
}

fifo_write(data)
uint16_t data;
{
    chk_wfr();
    *acrtc_io=data;
/*  printf("FIFO: %06x : %04x\n",acrtc_io,data); */
}

mode5()
{
// setup 640x480 16 colour single access mode (mivac mode 5)

// load colour palette

    *ptr_acrtc_cp_parw=0;
    uint8_t i;
    for (i=0;i<16;i++)
    {
        *ptr_acrtc_cp_cpr=colours[i].red;               /* red */
        *ptr_acrtc_cp_cpr=colours[i].green;             /* green */
        *ptr_acrtc_cp_cpr=colours[i].blue;              /* blue */
    }

// load pixel mask register

//  __asm__("move.b  #0b00001111,acrtc_cp_base_addr+acrtc_cp_prmr");    /* doesnt work */
    __asm__("move.b  #15,0xA90005");                                    /* temp solution */

    reg_write(acrtc_mwr1,mivac_mode_5_mw1);             /* load base (background) - memory width 1 register */
    reg_write(acrtc_ccr,0x0000|mivac_mode_5_gbm<<8);    /* load command control register */
    reg_write(acrtc_dcr,0xC000|mivac_mode_5_atr);       /* load display control register */
    reg_write(acrtc_omr,0xC000|mivac_mode_5_gai<<4|mivac_mode_5_acm<<2);    /* load operation mode register */

    *acrtc_ar=0;                   /* address the fifo */

    pr_write(acrtc_cl0,0x0000);    /* set background colour */
    pr_write(acrtc_cl1,0x8888);    /* set foreground colour */
}

colour(uint16_t colour)
{
    switch(colour)
    {
        case 0:
            colour=0x0000;
            break;
        case 1:
            colour=0x1111;
            break;
        case 2:
            colour=0x2222;
            break;
        case 3:
            colour=0x3333;
            break;
        case 4:
            colour=0x4444;
            break;
        case 5:
            colour=0x5555;
            break;
        case 6:
            colour=0x6666;
            break;
        case 7:
            colour=0x7777;
            break;
        case 8:
            colour=0x8888;
            break;
        case 9:
            colour=0x9999;
            break;
        case 10:
            colour=0xAAAA;
            break;
        case 11:
            colour=0xBBBB;
            break;
        case 12:
            colour=0xCCCC;
            break;
        case 13:
            colour=0xDDDD;
            break;
        case 14:
            colour=0xEEEE;
            break;
        case 15:
            colour=0xFFFF;
            break;
    }
    pr_write(0,colour);
    pr_write(1,colour);
}

cls(dn)
uint16_t dn;                       /* acrtc display number (0-3) */
{
    *acrtc_ar=0;                   /* address the fifo */
    pr_write(0x0c,dn*16384);       /* set RWP (read write pointer (high word) */
    pr_write(0x0d,0);              /* set RWP (read write pointer (low word)  */
    chk_ced();
    fifo_write(acrtc_clr);         /* write CLR command  */
    fifo_write(0);                 /* write D  parameter */
    fifo_write((HRES/PIXW)-1);     /* write AX parameter */
    fifo_write(0-(VRES-1));        /* write AY parameter */
}

org()
{
    chk_ced();
    fifo_write(0x0400);            /* write ORG command  */
    fifo_write(acrtc_dn*16384);    /* write DPH parameter */
    fifo_write(0);                 /* write DPL parameter */
}

line(x1,y1,x2,y2)
uint16_t x1,y1,x2,y2;
{
    chk_ced();
    fifo_write(acrtc_amove);       /* write AMOVE command */
    fifo_write(x1);                /* write X parameter   */
    fifo_write(0-y1);              /* write Y parameter   */
    chk_ced();
    fifo_write(acrtc_aline);       /* write ALINE command */
    fifo_write(x2);                /* write X parameter   */
    fifo_write(0-y2);              /* write Y parameter   */
}

rectangle(x1,y1,x2,y2)
uint16_t x1,y1,x2,y2;
{
    chk_ced();
    fifo_write(acrtc_amove);       /* write AMOVE command */
    fifo_write(x1);                /* write X parameter   */
    fifo_write(0-y1);              /* write Y parameter   */
    chk_ced();
    fifo_write(acrtc_arct);        /* write ARCT command  */
    fifo_write(x2);                /* write X parameter   */
    fifo_write(0-y2);              /* write Y parameter   */
}

circle(x,y,r)
uint16_t x,y,r;
{
    chk_ced();
    fifo_write(acrtc_amove);       /* write AMOVE command */
    fifo_write(x);                 /* write X parameter   */
    fifo_write(0-y);               /* write Y parameter   */
    chk_ced();
    fifo_write(acrtc_crcl);        /* write CRCL command  */
    fifo_write(r);                 /* write R parameter   */
}

dot(x,y)
uint16_t x,y;
{
    chk_ced();
    fifo_write(acrtc_amove);       /* write AMOVE command */
    fifo_write(x);                 /* write X parameter   */
    fifo_write(0-y);               /* write Y parameter   */
    chk_ced();
    fifo_write(acrtc_dot);         /* write DOT command  */
}

delay(t)
long t;
{
    while(t!=0)
    {
        t--;
    }
}
