#include <stdint.h>
#include <stdio.h>
//#include <math.h>

#include "acrtclib.c"

int main(void)
{
uint16_t vo=4;             /* margin - vertical offset */
uint16_t ho=4;             /* margin - horizontal offset */
uint16_t hs=320;           /* Horizontal & Vertical Shift */
uint16_t vs=10;
uint16_t mi=5000;          /* max iterations (fern detail) */
uint16_t n;

double r;
double xn=0;
double yn=0;
double x=0;
double y=0;

    puts("\nGraphics Demo4 V1.00\n");

    mode5();
    cls(1);
    org();

    colour(6);

    rectangle(0,0,acrtc_hr-1,acrtc_vr-1);              /* draw border */
    line(0,vo,acrtc_hr-1,vo);                          /* draw top & bottom margins */
    line(0,acrtc_vr-1-vo,acrtc_hr-1,acrtc_vr-1-vo);
    line(ho,0,ho,acrtc_vr-1);                          /* draw left & right margins */
    line(acrtc_hr-1-ho,0,acrtc_hr-1-ho,acrtc_vr-1);

    colour(2);

    for(n=1;n<=mi;n++)
    {
        int scale=1000000;                             /* define a large number for precision */
        r=(double)(rand() % scale) / scale;            /* generate a random number between 0 and 1 */

        if(r < 0.01)
        {
            xn=0;
            yn=0.16*y;
        }
        if(r >= 0.01 && r < 0.86)
        {
            xn= 0.85*x+0.04*y;
            yn=-0.04*x+0.85*y+1.6;
        }
        if(r >= 0.86 && r < 0.93)
        {
            xn=0.20*x-0.26*y;
            yn=0.23*x+0.22*y+1.6;
        }
        if(r >= 0.93)
        {
            xn=-0.15*x+0.28*y;
            yn= 0.26*x+0.24*y+0.44;
        }
        dot(hs+(int)(xn*45),acrtc_vr-vs-(int)(yn*45));
        x=xn;
        y=yn;
    }
    puts("Graphics Rendering Complete!\n");
    return 0;
}
