#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>

// function to check a string contains only hexadecimal characters
// returns true if hexadecimal, false if not
bool is_hex_string(const char *str)
{
    if(!str)
        return false; // Handle null pointer
    while(*str)
    {
        if(!isxdigit((unsigned char)*str))
            return false;
        str++;
    }
    return true;
}

main(int argc, char *argv[])
{
    puts("");
    if(argc!=3)
    {
        puts("SHOWMEM V1.00 by Steve Crompton");
        puts("Displays the contents of memory");
        puts("");
        puts("  Syntax: SHOWMEM arg1 arg2");
        puts("  arg1:   start address in hexadecimal");
        puts("  arg2:   number of bytes to display in hexadecimal");
        puts("");
        return 0;
    }
    char *hexString1 = argv[1];
    char *hexString2 = argv[2];
    // check the strings
    if(!is_hex_string(hexString1))
    {
        printf("  Invalid arg1: %s\n\n",hexString1);
        return 0;
    }
    if(!is_hex_string(hexString2))
    {
        printf("  Invalid arg2: %s\n\n",hexString2);
        return 0;
    }
    // Convert the valid hexadecimal strings to integers
    long hexValue1=strtol(hexString1,NULL,16);
    long hexValue2=strtol(hexString2,NULL,16);
    volatile uint8_t *address = (volatile uint8_t*)hexValue1;
    int32_t bytes = hexValue2;
    int i;
    uint8_t data;    
    uint8_t ascii[17];
    ascii[16]='\0';
    while(bytes>0)
    {
        for(i=0;i<16;i++)
        {
            data=*address;
            // do the ascii
            if(data<32)
                ascii[i]='.';
            if(data>=32 && data<127)
                ascii[i]=data;
            else
                ascii[i]='.';
            // do the hex
            if(i==0)
                printf("%06X    ",address);
            printf("%02X ",data);
            if(i==7)
                printf(" ");
            if(i==15)
                printf(" %s\n", ascii);
            address++;
        }
        bytes-=16;
    }
    puts("");
    return 0;
}
